﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample9
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool FlashWindowEx(ref FlashWInfo pwfi);

        [StructLayout(LayoutKind.Sequential)]
        public struct FlashWInfo
        {
            public UInt32 cbSize;
            public IntPtr hwnd;
            public FlashWInfoFlags dwFlags;
            public UInt32 uCount;
            public UInt32 dwTimeout;

            public static UInt32 SizeOf
            {
                get { return (UInt32)Marshal.SizeOf(typeof(FlashWInfo)); }
            }
        }

        public enum FlashWInfoFlags : uint
        {
            FlashW_Stop = 0x0,
            FlashW_Caption = 0x1,
            FlashW_Tray = 0x2,
            FlashW_All = 0x3,
            FlashW_Timer = 0x4,
            FlashW_TimerOfg = 0x12
        }

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonStart_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = this.Handle;
            FlashWInfo fInfo = new FlashWInfo();

            fInfo.cbSize = FlashWInfo.SizeOf;
            fInfo.hwnd = hWnd;
            fInfo.dwFlags = FlashWInfoFlags.FlashW_All | FlashWInfoFlags.FlashW_Timer;
            fInfo.uCount = 0;
            fInfo.dwTimeout = 0;
            FlashWindowEx(ref fInfo);
        }

        private void buttonStop_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = this.Handle;
            FlashWInfo fInfo = new FlashWInfo();

            fInfo.cbSize = FlashWInfo.SizeOf;
            fInfo.hwnd = hWnd;
            fInfo.dwFlags = FlashWInfoFlags.FlashW_Stop;
            fInfo.uCount = 0;
            fInfo.dwTimeout = 0;
            FlashWindowEx(ref fInfo);
        }
    }
}